#   configuration module for flosPCB.py

from tkinter import *
from tkinter.ttk import *
import json
from draw import *
        
# misc globals
lines = []
vias = []
opt = ''
OPT = ''
cutout = ''
io = ''
IO = ''
params = {}
param_file_name = 'config.json'

def get_params():
    return params

def getParam(key):
    return params[key]

def save_params(filename = param_file_name):
    global params
    f = open(param_file_name, 'w')
    json.dump(params, f)
    f.close()
     
def fetch_params(filename = param_file_name):
    global params
    try:
        f = open( param_file_name, 'r')    
        params = json.load(f)
        f.close()
        return params
    except:
        params = set_default_params()
        
    print('fetched params:\n',params)        
    if (params['nCols'] == ''):
        set_default_params()
        
def set_default_params():
    global params
    print('setting param defaults')
    params['thick'] = 0.070     # pcb total thickness
    params['depth'] = 0.010     # copper layer thickness
    params['trvlRate'] = 200    # mm/min to travel
    params['etchRate'] = 200    # mm/min to etch cells 
    params['cutRate'] = 100     # mm/min to cut out board
    params['drillRate'] = 50    # mm/min to drill holes
    params['xMargin'] = 0.2     # left to right margin, each end
    params['yMargin'] = 0.2     # top to bottom margin, each side
    params['tab'] = 0.02        # width of tabs
    params['header'] = 'G54 G17 G94 G90 G20' # machine initialization
    params['homeHt'] = 2.0      # homeing height, clear of board
    params['trvlHt'] = 0.3      # clearance while moving between sites
    params['nRows'] = 6
    params['nCols'] = 12
    params['cellSize'] = 0.2
    params['homer'] = 'G0 Z2.0 G0 X0 Y0'    # gcode to home CNC
    params['folder'] = ''       # where to store parameter file
    params['gridSize'] = params['cellSize'] *100
    params['scale'] = 100 # pixels/inch  # for drawing only
    params['lineNmbrs'] = 1     # 1=yes, 0=no,  for gcode editor

    # default color scheme
    params['select_color'] = 'magenta'
    params['bg_color'] = 'white'
    params['line_color'] = 'green'
    params['via_color'] = 'blue'
    params['grid_color'] = 'black'
    params['border_color'] = 'yellow'
    params['draw_color'] = 'red'
    return params

def do_programOpts(root):
    global params
    #print('params=\n',params)
    inputDialog = ProgramDialog(root, params['folder'],params['lineNmbrs'])
    root.wait_window(inputDialog.top)
    if inputDialog.folder is not None:
        params['folder'] = inputDialog.folder
        params['lineNmbrs'] = inputDialog.lineNmbrs
        save_params()
    
def do_machineOpts(root):
    inputDialog = MachineParameterDialog(root,
            params['trvlRate'],params['etchRate'],params['cutRate'],params['drillRate'],
            params['xMargin'],params['yMargin'],params['tab'],params['homeHt'],params['trvlHt'])
    root.wait_window(inputDialog.top)
    if inputDialog.trvlRate is not None:
        params['trvlRate'] = inputDialog.trvlRate
        params['etchRate'] = inputDialog.etchRate
        params['cutRate'] = inputDialog.cutRate
        params['drillRate'] = inputDialog.drillRate
        params['xMargin'] = inputDialog.xMargin
        params['yMargin'] = inputDialog.yMargin
        params['tab'] = inputDialog.tab
        params['homeHt'] = inputDialog.homeHt
        params['trvlHt'] = inputDialog.trvlHt
        save_params()
        
def do_gcodeOpts(root):
    inputDialog = GcodeDialog(root, params['header'],params['homer'])
    root.wait_window(inputDialog.top)
    if inputDialog.header is not None:
        params['header'] = inputDialog.header
        params['homer'] = inputDialog.homer
        save_params()

def do_pcbOpts(root):
    inputDialog = pcbDialog(root, params['cellSize'], params['nRows'], params['nCols'], params['thick'], params['depth'])
    root.wait_window(inputDialog.top)
    if inputDialog.cellSize is not None:
        params['cellSize'] = float(inputDialog.cellSize)
        params['nRows'] = int(inputDialog.nRows)
        params['nCols'] = int(inputDialog.nCols)
        params['thick'] = float(inputDialog.thick)
        params['depth'] = float(inputDialog.depth)
        save_params()
    
class ProgramDialog:
    def __init__(self, parent, folder, lineNmbrs):
        self.top = Toplevel(parent)
        self.top.transient(parent)
        frm = Frame(self.top)
        frm.grid(row=0, column=0, sticky=W+N)
        Label(frm, text='General').grid(row=0, column=0, sticky=N)
        
        Label(frm, text='Gcode Folder: ').grid(row=1, column=1, sticky=W)
        self.folder = StringVar()
        self.folder.set(folder)
        self.folder_widget = Entry(frm, width=40, textvariable=self.folder)
        self.folder_widget.grid(row=1, column=2,columnspan=3, sticky=W)
        
        Label(frm, text='Line Numbers: ').grid(row=2, column=1, sticky=W)
        self.lineNmbrs = IntVar()
        self.lineNmbrs.set(lineNmbrs)
        self.lineNmbrs_widget = Checkbutton(frm, width=40, variable=self.lineNmbrs)
        self.lineNmbrs_widget.grid(row=2, column=2, sticky=W)
        
        self.mySubmitButton = Button(frm, text='Save', command=self.send)
        self.mySubmitButton.grid(row=3, column=2, sticky=W, pady=4)
        self.myCancelButton = Button(frm, text='Cancel', command=self.cancel)
        self.myCancelButton.grid(row=3, column=4, sticky=W, pady=4)

    def send(self):
        self.folder = self.folder.get()
        self.lineNmbrs = self.lineNmbrs.get()
        self.top.destroy()
        
    def cancel(self):
        self.folder=None
        self.top.destroy()

class GcodeDialog:
    def __init__(self, parent, hdr, hom):
        self.top = Toplevel(parent)
        self.top.transient(parent)
        frm = Frame(self.top)
        frm.grid(row=0, column=0, sticky=W+N)
        Label(frm, text='G-Code').grid(row=0, column=0, sticky=N)
        
        Label(frm, text='Header: ').grid(row=1, column=1, sticky=W)
        self.hdr = StringVar()
        self.hdr.set(hdr)
        self.hdr_widget = Entry(frm, width=40, textvariable=self.hdr)
        self.hdr_widget.grid(row=1, column=2, columnspan=3, sticky=W)
        
        Label(frm, text='Home: ').grid(row=2, column=1, sticky=W)
        self.hom = StringVar()
        self.hom.set(hom)
        self.hom_widget = Entry(frm, width=40, textvariable=self.hom)
        self.hom_widget.grid(row=2, column=2, columnspan=3, sticky=W)
        
        self.mySubmitButton = Button(frm, text='Save', command=self.send)
        self.mySubmitButton.grid(row=3, column=2, sticky=W, pady=4)
        self.myCancelButton = Button(frm, text='Cancel', command=self.cancel)
        self.myCancelButton.grid(row=3, column=4, sticky=W, pady=4)

    def send(self):
        self.header = self.hdr_widget.get()
        self.homer = self.hom_widget.get()
        self.top.destroy()
        
    def cancel(self):
        self.header=None
        self.top.destroy()

class MachineParameterDialog:
    def __init__(self, parent, trvl,etch,cut,drill,xMar,yMar,tab,homeHt,trvlHt):
        self.top = Toplevel(parent)
        self.top.transient(parent)
        frm = Frame(self.top, borderwidth=4, relief='ridge')
        frm.grid(row=0, column=0, sticky=W+N)
        Label(frm, text='Persistent Machine Parameters').grid(row=0, column=1, sticky=N)
        
        Label(frm, text='Travel Rate (mm/min): ').grid(row=1, column=0, sticky=W)
        self.trvlRate = IntVar()
        self.trvlRate.set(trvl)
        self.trvl_widget = Spinbox(frm, from_=50, to=500, width=4, textvariable=self.trvlRate)
        self.trvl_widget.grid(row=1, column=25, sticky=W)
        
        Label(frm, text='Etching Rate (mm/min): ').grid(row=2, column=0, sticky=W)
        self.etchRate = IntVar()
        self.etchRate.set(etch)
        self.etch_widget = Spinbox(frm, from_=50, to=500, width=4, textvariable=self.etchRate)
        self.etch_widget.grid(row=2, column=25, sticky=W)
        
        Label(frm, text='Cut Free Rate (mm/min): ').grid(row=3, column=0, sticky=W)
        self.cutRate = IntVar()
        self.cutRate.set(cut)
        self.cut_widget = Spinbox(frm, from_=50, to=500, width=4, textvariable=self.cutRate)
        self.cut_widget.grid(row=3, column=25, sticky=W)
        
        Label(frm, text='Drill Rate (mm/min): ').grid(row=4, column=0, sticky=W)
        self.drillRate = IntVar()
        self.drillRate.set(drill)
        self.drill_widget = Spinbox(frm, from_=10, to=100, width=4, textvariable=self.drillRate)
        self.drill_widget.grid(row=4, column=25, sticky=W)
        
        Label(frm, text='X Margin (in.): ').grid(row=5, column=0, sticky=W)
        self.xMargin = DoubleVar()
        self.xMargin.set(xMar)
        self.xMargin_widget = Spinbox(frm, from_=0.0, to=1.0, increment=0.1, width=4, textvariable=self.xMargin)
        self.xMargin_widget.grid(row=5, column=25, sticky=W)
        
        Label(frm, text='Y Margin (in.): ').grid(row=6, column=0, sticky=W)
        self.yMargin = DoubleVar()
        self.yMargin.set(yMar)
        self.yMargin_widget = Spinbox(frm, from_=0.0, to=1.0, increment=0.1, width=4, textvariable=self.yMargin)
        self.yMargin_widget.grid(row=6, column=25, sticky=W)

        Label(frm, text='Tab Width (in.): ').grid(row=7, column=0, sticky=W)
        self.tab = DoubleVar()
        self.tab.set(tab)
        self.tab_widget = Spinbox(frm, from_=0.1, to=1.00, increment=0.1, width=4, textvariable=self.tab)
        self.tab_widget.grid(row=7, column=25, sticky=W)
        
        Label(frm, text='Home Height (in.): ').grid(row=8, column=0, sticky=W)
        self.homeHt = DoubleVar()
        self.homeHt.set(homeHt)
        self.homeHt_widget = Spinbox(frm, from_=0.1, to=3.0, increment=0.1, width=4, textvariable=self.homeHt)
        self.homeHt_widget.grid(row=8, column=25, sticky=W)
        
        Label(frm, text='Travel Height (in.): ').grid(row=9, column=0, sticky=W)
        self.trvlHt = DoubleVar()
        self.trvlHt.set(trvlHt)
        self.trvlHt_widget = Spinbox(frm, from_=0.1, to=1.0, increment=0.1, width=4, textvariable=self.trvlHt)
        self.trvlHt_widget.grid(row=9, column=25, sticky=W)
        
        self.mySubmitButton = Button(frm, text='Save', command=self.send)
        self.mySubmitButton.grid(row=10, column=5, sticky=W)
        self.myCancelButton = Button(frm, text='Cancel', command=self.cancel)
        self.myCancelButton.grid(row=10, column=25, sticky=W)

    def send(self):
        self.trvlRate = int(self.trvl_widget.get())
        self.etchRate = int(self.etch_widget.get())
        self.cutRate = int(self.cut_widget.get())
        self.drillRate = int(self.drill_widget.get())
        self.xMargin = float(self.xMargin_widget.get())
        self.yMargin = float(self.yMargin_widget.get())
        self.tab = float(self.tab_widget.get())
        self.homeHt = float(self.homeHt_widget.get())
        self.trvlHt = float(self.trvlHt_widget.get())
        self.top.destroy()
        
    def cancel(self):
        self.trvlRate=None
        self.top.destroy()

class pcbDialog:
    def __init__(self, parent, cellSize,nRows,nCols,thick,depth):
        self.top = Toplevel(parent)
        frm = Frame(self.top)
        frm.grid(row=0, column=0, sticky=W+N)
        Label(frm, text='PCB').grid(row=0, sticky=N)
                
        Label(frm, text='Isolated Cell Size (inches): ').grid(row=1, column=2, sticky =W)
        self.cellSize = DoubleVar()
        self.cellSize.set(cellSize)
        self.cellSize_widget = Spinbox(frm, from_=0.1, to=1.0, increment=0.1, width=5, textvariable=self.cellSize)
        self.cellSize_widget.grid(row=1, column=30, sticky =W)
        self.cellSize = float(self.cellSize_widget.get())
        
        Label(frm, text='# Horizontal Rows (Y) : ').grid(row=2, column=2, sticky=W)
        self.nRows = IntVar()
        self.nRows.set(nRows)
        self.nRow_widget = Spinbox(frm, from_=1, to=50, width=5, textvariable=self.nRows)
        self.nRow_widget.grid(row=2, column=30)
        self.nRows = int(self.nRow_widget.get())
        
        Label(frm, text='# Vertical Columns (X): ').grid(row=3, column=2, sticky=W)
        self.nCols = IntVar()
        self.nCols.set(nCols)
        self.nCol_widget = Spinbox(frm, from_=1, to=50, width=5, textvariable=self.nCols,)
        self.nCol_widget.grid(row=3, column=30, sticky=W)
        self.nCols = int(self.nCol_widget.get())
       
        Label(frm, text='BoardThickness (inches): ').grid(row=4, column=2, sticky=W)
        self.thick = DoubleVar()
        self.thick.set(thick)
        self.thick_widget = Spinbox(frm, from_=0.01, to=0.25, increment=0.01, width=5, textvariable=self.thick)
        self.thick_widget.grid(row=4, column=30, sticky=W)
        self.thick = float(self.thick_widget.get())
        
        Label(frm, text='CopperThickness (inches): ').grid(row=5, column=2, sticky=W)
        self.depth = DoubleVar()
        self.depth.set(depth)
        self.depth_widget = Spinbox(frm, from_=0.005, to=0.1, increment=0.001, width=5, textvariable=self.depth)
        self.depth_widget.grid(row=5, column=30, sticky=W)
        self.depth = float(self.depth_widget.get())
        
        self.mySubmitButton = Button(frm, text='Save', command=self.send)
        self.mySubmitButton.grid(row=7, column=2, sticky=W, pady=4)
        self.myCancelButton = Button(frm, text='Cancel', command=self.cancel)
        self.myCancelButton.grid(row=7, column=25, sticky=W, pady=4)

    def send(self):
        self.cellSize = self.cellSize_widget.get()
        self.nRows = self.nRow_widget.get()
        self.nCols = self.nCol_widget.get()
        self.thick = self.thick_widget.get()
        self.depth = self.depth_widget.get()
        self.top.destroy()
        
    def cancel(self):
        self.header=None
        self.top.destroy()


