from tkinter import *
from tkinter.ttk import *
from tkinter import filedialog
import os

from config import *

class Gcode():
    def __init__(self, root, row, col):
        #print('prepping gcode edit area')      
        self.root = root
        self.saved = False
        self.base_row = row
        self.base_col = col
        self.gcode_filename = None
        
    def create_editor(self):
        editFrame = Frame(self.root, borderwidth=2, relief='ridge')
        editFrame.grid(row=self.base_row, column=self.base_col, sticky=W+N+S)
        
#        lineNmbrBar = Text(editFrame, width=4, padx=3, takefocus=0, border=0,
#                           background='khaki', state='disabled', wrap='none')
#        lineNmbrBar.grid(row=1, column=0, sticky=N+S)
        
#        Label(editFrame, text='G-Code Preview: ').grid(row=0, column=0, sticky=N)
        self.scrollBar = Scrollbar(editFrame)
        self.content = Text(editFrame, yscrollcommand=self.scrollBar.set, width=50,
                            background='light sea green')
        self.scrollBar.config(command=self.content.yview)
        self.content.grid(row=0, column=10, pady=2, sticky=E+W+N+S)
        self.scrollBar.grid(row=0, column=75, sticky=N+S+E)

    def make_popupMenu(self):
        self.popup_menu = Menu(self.content)
        for i in ('cut', 'copy', 'paste', 'undo', 'redo'):
            cmd = eval('self.'+i)
            self.popup_menu.add_command(label=i, compound='left', command=cmd)
#        self.popup_menu.add_seperator()
#        self.popup_menu.add_command(label='Select_All', underline=7, comand=select_all)
        self.content.bind('<Button-3>', self.show_popupMenu)

    def show_popupMenu(self, event):
        self.popup_menu.tk_popup(event.x_root, event.y_root)
        
    # ----- file handling -----#
    def filenew(self, event=None):
#        root.title("Untitled")
        self.gcode_filename = None
        self.content.delete(1.0, END)
        self.saved = False

    def fileopen(self):
        gcodeFolder = getParam('folder')
        input_filename = filedialog.askopenfilename (defaultextension=".nc",
            filetypes=[("g-code Files","*.nc"), ("Text Files","*.txt"), ("all Files", "*.*")],
            initialdir=gcodeFolder)
        if input_filename:
            self.gcode_filename = input_filename
#            self.root.title('{} - {}'.format(os.path.basename(self.gcode_filename), self.root.PROGRAM_NAME))
            self.content.delete(1.0, END)
            with open(self.gcode_filename) as the_file:
                self.content.insert(1.0, the_file.read())
            self.saved = False
        
    def filesave(self):
        #print('saving')
        gcodeFolder = getParam('folder')
        if not self.gcode_filename:
            self.filesaveas()
        else:
            self.write_to_file()
        return "break"

    def filesaveas(self):
        #print('saving as ...')
        gcodeFolder = getParam('folder')
        input_filename = filedialog.asksaveasfilename (defaultextension=".nc",
            filetypes=[("g-code Files","*.nc"), ("Text Files","*.txt"), ("all Files", "*.*")],
            initialdir=gcodeFolder)
        if input_filename:
            self.gcode_filename = input_filename
            self.write_to_file()
#            self.root.title('{} - {}'.format(os.path.basename(self.gcode_filename), self.root.PROGRAM_NAME))
        return "break"
                 
    def write_to_file(self):
        try:
            gcode = self.content.get(1.0, 'end')
            with open(self.gcode_filename, 'w') as the_file:
                the_file.write(gcode)
            self.saved = True
        except IOError:
            pass

    # ----- context menu commands ----- #
    def cut(self, event):
        self.content.event_generate("<<Cut>>")
        #on_content_changed()
        return "break"

    def copy(self, event):
        self.content.event_generate("<<Copy>>")
        return "break"

    def paste(self, event):
        self.content.event_generate("<<Paste>>")
        #on_content_changed()
        return "break"

    def undo(self, event):
        self.content.event_generate("<<Undo>>")
        #on_content_changed()
        return "break"

    def redo(self, event=None):
        self.content.event_generate("<<Redo>>")
        #on_content_changed()
        return 'break'
    
    #----- gcode generation -----#
    def addGcode(self, text):
        self.ln = self.ln+1
        ln = "%d.0" % (self.ln)
        self.content.insert(ln, text+"\n")

    def delAllGcode(self):
        self.content.delete("1.0",END)

    def initGcode(self):
        params = get_params()
        self.ln = 0
        self.addGcode("(--- Header ---)")
        self.addGcode(params['header'])
        self.addGcode("F%d" % (params['trvlRate']))
        self.addGcode("G00 Z+%0.2f" % (params['trvlHt']))

    def goHome(self):
        homeHt = getParam('homeHt')
        self.addGcode("(--- Homing ---)")
        self.addGcode("G00 Z+%0.2f" % (homeHt))
        self.addGcode("G00 x0 y0")

    def adj(self,xy):
        i = 0
        ab = list()
        params = get_params()
        xMax = (((params['nCols']+1)+2)*params['cellSize']) * params['scale']
        #print('xMax=',xMax)
        yMax = (((params['nRows']+1)+1)*params['cellSize']) * params['scale']
        #print('yMax=',yMax)
        for n in xy:
            #print('xy[',i,']=',xy[i])
            #xy[i] = xy[i]/params['scale']
            if (i % 2) == 0:
                #ab.append((xMax - xy[i])/params['scale'])
                ab.append((xy[i])/params['scale'])
                #print('adj x = ',ab[i])
            else:
                ab.append((yMax - xy[i])/params['scale'])
                #print('adj y = ',ab[i])
            i = i+1
        return ab
    
    def makeLineGcode(self, canvas):
        objList = canvas.find_withtag('line')
        if len(objList) == 0: return

        params = get_params()
        n = 0
        for obj in objList:
            n = n+1
            xy0 = canvas.coords(obj)
            xy = self.adj(xy0)
            self.addGcode("(---- line #%d ----)" % (n))
            self.addGcode("(move to start) G00 x%0.2f y%0.2f" % (xy[0],xy[1]))
            self.addGcode("(bit down) G01 z-%0.3f F%d" % (params['depth'], params['drillRate']))
            self.addGcode("(move) G01 x%0.2f y%0.2f F%d" %(xy[2],xy[3], params['etchRate']))
            self.addGcode("(moving height) G00 z+%0.3f" % (params['trvlHt']))
            
    def makeRectangleGcode(self, canvas):
        objList = canvas.find_withtag('rect')
        if len(objList) == 0: return

        params = get_params()
        n = 0
        for obj in objList:
            n = n+1
            self.addGcode("(---- rectangle #%d ----)" % (n))
            xy = canvas.coords(obj)
            xy = self.adj(xy)
            #print(xy)
            self.addGcode("(move to start) G00 x%0.2f y%0.2f" % (xy[0],xy[1]))
            self.addGcode("(bit down) G01 z-%0.3f F%d" % (params['depth'], params['drillRate']))
            self.addGcode("(top) G01 x%0.2f y%0.2f F%d" %(xy[2],xy[1], params['etchRate']))
            self.addGcode("(right) G01 x%0.2f y%0.2f F%d" %(xy[2],xy[3], params['etchRate']))
            self.addGcode("(bottom) G01 x%0.2f y%0.2f F%d" %(xy[0],xy[3], params['etchRate']))
            self.addGcode("(left) G01 x%0.2f y%0.2f F%d" %(xy[0],xy[1], params['etchRate']))
            self.addGcode("(bit up) G00 z+%0.3f" % (params['trvlHt']))
        
    def makePolygonGcode(self, canvas):
        objList = canvas.find_withtag('poly')
        if len(objList) == 0: return

        params = get_params()
        n = 0
        for obj in objList:
            n = n+1
            self.addGcode("(---- polygon #%d ----)" % (n))
            xy = canvas.coords(obj)
            xy = self.adj(xy)
            print(xy)
            x = xy.pop(0)
            y = xy.pop(0)
            self.addGcode("(move to start) G00 x%0.2f y%0.2f" % (x,y))
            self.addGcode("(bit down) G01 z-%0.3f F%d" % (params['depth'], params['drillRate']))
            while len(xy) > 0:
                x = xy.pop(0)
                y = xy.pop(0)
                self.addGcode("(move) G01 x%0.2f y%0.2f F%d" %(x,y, params['etchRate']))
            self.addGcode("(bit up) G00 z+%0.3f" % (params['trvlHt']))
        
    def makeViaGcode(self, canvas):
        objList = canvas.find_withtag('via')
        if len(objList) == 0: return

        params = get_params()
        n = 0
        for obj in objList:
            n = n+1
            xy0 = canvas.coords(obj)
            xy = self.adj(xy0)
            x = float(xy[0] + xy[2])/2.0
            y = float(xy[1] + xy[3])/2.0
            self.addGcode("(---- via #%d ----)" % (n))
            #self.addGcode("(#### drilling via ####)")
            self.addGcode("(move to location) G00 x%0.2f y%0.2f" % (x,y))
            self.addGcode("(mark VIA) G01 z-%0.3f F%d" % (params['thick']+0.005, params['drillRate']))
            self.addGcode("(bit up) G00 z+%0.3f" % (params['trvlHt']))
        
    #--- border ---#
    def brdrGcode(self, x0,y0, x1,y1, deep, tabYes):
        params = get_params()
        #self.addGcode("(set deep cut feed rate) F%d" % (self.cutRate/2))
        self.addGcode("(move to start) G00 x%0.2f y%0.2f" % (x0,y0))
        self.addGcode("(bit down) G01 z-%0.3f F%d" % (deep, params['drillRate']))      
        self.addGcode("(set deep cut feed rate) F%d" % (params['cutRate']/2))
        
        if (tabYes):
            halfTab = params['tab'] / 2.0
            hMid = (x0 + x1)/2.0
            hTab0 = hMid - halfTab
            hTab1 = hMid + halfTab
            vMid = (y0 + y1)/2.0
            vTab0 = vMid - halfTab
            vTab1 = vMid + halfTab
            
        if (tabYes):
            self.addGcode("(left 1st half) G01 x%0.2f y%0.2f" %(x0,vTab0))
            self.addGcode("(bit up) G01 z+%0.3f" % (params['trvlHt']))
            self.addGcode("(skip tab) G01 x%0.2f y%0.2f" %(x0,vTab1))
            self.addGcode("(bit down) G01 z-%0.3f" % (deep))
            self.addGcode("(left 2nd half) G01 x%0.2f y%0.2f" %(x0,y1))
        else:
            self.addGcode("(left) G01 x%0.2f y%0.2f" %(x0,y1))

        if (tabYes):
            self.addGcode("(top 1st half) G01 x%0.2f y%0.2f" %(hTab0,y1))
            self.addGcode("(bit up) G01 z+%0.3f" % (params['trvlHt']))
            self.addGcode("(skip tab) G01 x%0.2f y%0.2f" %(hTab1,y1))
            self.addGcode("(bit down) G01 z-%0.3f" % (deep))
            self.addGcode("(top 2nd half) G01 x%0.2f y%0.2f" %(x1,y1))
        else:
            self.addGcode("(top) G01 x%0.2f y%0.2f" %(x1,y1))

        if (tabYes):
            self.addGcode("(right 1st half) G01 x%0.2f y%0.2f" %(x1,vTab1))
            self.addGcode("(bit up) G01 z+%0.3f" % (params['trvlHt']))
            self.addGcode("(skip tab) G01 x%0.2f y%0.2f" %(x1,vTab0))
            self.addGcode("(bit down) G01 z-%0.3f" % (deep))
            self.addGcode("(right 2nd half) G01 x%0.2f y%0.2f" %(x1,y0))
        else:
            self.addGcode("(right) G01 x%0.2f y%0.2f" %(x1,y0))

        if (tabYes):
            self.addGcode("(bottom 1st half) G01 x%0.2f y%0.2f" %(hTab1,y0))
            self.addGcode("(bit up) G01 z+%0.3f" % (params['trvlHt']))
            self.addGcode("(skip tab) G01 x%0.2f y%0.2f" %(hTab0,y0))
            self.addGcode("(bit down) G01 z-%0.3f" % (deep))
            self.addGcode("(bottom 2nd half) G01 x%0.2f y%0.2f" %(x0,y0))
        else:
            self.addGcode("(bottom) G01 x%0.2f y%0.2f" %(x0,y0))
            
        self.addGcode("(bit up) G00 z+%0.3f" % (params['trvlHt']))
            
    def makeBorderGcode(self, canvas):
        objList = canvas.find_withtag('bord')
        if len(objList) == 0: return

        # border is a set of lines, but we draw as a single entity
        params = get_params()
        n = 0
        tabYes = True
        tabNo = False
        xbl = 9999
        ybl = 9999
        xtr = 0
        ytr = 0
        #self.addGcode("(---- Border ----)")
        for obj in objList:
            xy = canvas.coords(obj)
            xy = self.adj(xy)
            #print(xy)
            xbl = min(xbl, xy[0], xy[2])
            ybl = min(ybl, xy[1], xy[3])
            xtr = max(xtr, xy[0], xy[2])
            ytr = max(ytr, xy[1], xy[3])
            #print('xbl=',xbl,', ybl=',ybl, '; xtr=',xtr,', ytr=',ytr)
        x0 = xbl #- float(self.xMargin)
        x1 = xtr #+ float(self.xMargin)
        y0 = ybl #- float(self.yMargin)
        y1 = ytr #+ float(self.yMargin)
        self.addGcode("(==== marking border ====)")
        self.brdrGcode(x0,y0, x1,y1, (params['thick']/2.0), tabNo)
        self.addGcode("(==== cutting board loose ====)")
        self.brdrGcode(x0,y0, x1,y1, params['thick']+0.005, tabYes)

    
