<?php
	/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
	 * See the file COPYRIGHT.html for more details.
	 */

    #### --- For those unable to set their time zone in PHP.ini --- ####
    #### for valid entries see: http://www.php.net/manual/en/timezones.php
    //date_default_timezone_set ( "America/New_York" );
	//echo "at start of common.php <br />\n";

    # Forcibly disable register_globals
    if (ini_get('register_globals')) {
    	foreach ($_REQUEST as $k=>$v) {
    		unset(${$k});
    	}
    	foreach ($_ENV as $k=>$v) {
    		unset(${$k});
    	}
    	foreach ($_SERVER as $k=>$v) {
    		unset(${$k});
    	}
    }

    ## Activate assertions and make them quiet
    assert_options(ASSERT_ACTIVE, 1);
    assert_options(ASSERT_WARNING, 0);
    assert_options(ASSERT_QUIET_EVAL, 1);

    ## Create a handler function
    function obAssertHandler($file, $line, $code, $desc = null) {
      echo "Assertion failed at file:'{$file}', line:'{$line}', code:'{$code}";
      if ($desc) echo ": $desc";
      echo "<br/>\n";
    }
    ## Set up the callback
    assert_options(ASSERT_CALLBACK, 'obAssertHandler');

//error_reporting(E_ALL);
//error_reporting(E_ALL & ~(E_STRICT | E_NOTICE));
error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT | E_NOTICE));
## following are for developer debug only
ini_set("display_errors", 1);
	//apd_set_pprof_trace();    // use with caution in sever cases only

	if (isset($cache)) {
		session_cache_limiter($cache);
	} else {
		session_cache_limiter('nocache');
	}

	function getOBroot() {
		// obtain OpenBiblio path ref to wep pages root
		// may be useful later in system (thinking plug-ins, etc.)
		$thisApp = $_SERVER[PHP_SELF];
		$thisPath = pathinfo($thisApp, PATHINFO_DIRNAME);
		$pathParts = explode('/',$thisPath);
		$OBroot = '/'.$pathParts[1].'/';
		return $OBroot;
	}

	/* Convenience functions for everywhere */
	/* Work around PHP's brain-dead include_path stuff. - MS */
	function REL($sf, $if) {
		return dirname($sf)."/".$if;
	}
	
/* -- no longer used? FL May 2016
	// This one should be used by all the form handlers that return errors.
	function _mkPostVars($arr, $prefix) {
		$pv = array();
		foreach ($arr as $k => $v) {
			if ($prefix !== NULL) {
				$k = $prefix."[$k]";
			}
			if (is_array($v)) {
				$pv = array_merge($pv, _mkPostVars($v, $k));
			} else {
				$pv[$k] = $v;
			}
		}
		return $pv;
	}
	function mkPostVars() {
		return _mkPostVars($_REQUEST, NULL);
	}
*/


	### needs to be here so changes in settings are picked up when changes are entered
	function setSessionFmSettings() {
		//echo "setting session variables <br />\n";    // prints at top of page before "<html...>"
		$_SESSION['itemBarcode_flg'] = Settings::get('item_barcode_flg');
		$_SESSION['item_autoBarcode_flg'] = Settings::get('item_autoBarcode_flg');
		$_SESSION['item_barcode_width'] = Settings::get('item_barcode_width');
		$_SESSION['mbrBarcode_flg'] = Settings::get('mbr_barcode_flg');
		$_SESSION['mbr_autoBarcode_flg'] = Settings::get('mbr_autoBarcode_flg');
		$_SESSION['mbr_barcode_width'] = Settings::get('mbr_barcode_width');
		$_SESSION['allow_plugins_flg'] = Settings::get('allow_plugins_flg');
		$_SESSION['plugin_list'] = Settings::get('plugin_list');
		$_SESSION['show_checkout_mbr'] = Settings::get('show_checkout_mbr');
		$_SESSION['show_detail_opac'] = Settings::get('show_detail_opac');
		$_SESSION['multi_site_func'] = Settings::get('multi_site_func');
		$_SESSION['show_item_photos'] = Settings::get('show_item_photos');
		$_SESSION['site_login'] = Settings::get('site_login');
		$_SESSION['checkout_interval'] = Settings::get('checkout_interval');
	}

	require_once(REL(__FILE__, '../shared/global_constants.php'));
	require_once(REL(__FILE__, '../classes/Error.php'));
	require_once(REL(__FILE__, "../classes/Nav.php"));
	require_once(REL(__FILE__, "../classes/Localize.php"));
	require_once(REL(__FILE__, '../shared/templates.php'));
    require_once(REL(__FILE__, "../functions/supportFuncs.php"));
	require_once(REL(__FILE__, "../model/Settings.php"));

	global $LOC, $CharSet, $Locale, $OBroot;
	global $ThemeId, $ThemeDirUrl, $ThemeDir, $SharedDirUrl;
	global $LocaleDirUrl, $LocaleDir, $SharedDirUrl, $HTMLHead;

	$LOC = new Localize;
	if (!isset($doing_install) or !$doing_install) {
        ## normal processing
		include_once(REL(__FILE__, "../model/Settings.php"));
		//echo "in common.php @ln#124 <br />\n";
		Settings::load();
		//echo "in common.php @ln#126 <br />\n";
		$CharSet = Settings::get('charset');
		$ThemeId = Settings::get('themeid');
		$ThemeDirUrl = trim(Settings::get('theme_dir_url'));
		$Locale = Settings::get('locale');
	}
	else {
        ## startup / install only
		$CharSet = "UTF-8";
		$ThemeId = '1';
		$ThemeDirUrl = "../themes/default";
        //$localeStrs = explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']);
        //$Locale = substr($localeStrs[0],0,2);
		//echo "this locale is: $Locale <br />\n";
		$Locale = 'en';
	}

	$ThemeDir = REL(__FILE__, $ThemeDirUrl);
	$SharedDirUrl = "../shared";
	$HTMLHead = "";
	$LocaleDirUrl = "../locale/".$Locale;
	$LocaleDir = REL(__FILE__, $LocaleDirUrl);

	if (!isset($doing_install) or !$doing_install) {
		## Get the current Session Timeout Value
		$currentTimeoutInSecs = ini_get('session.gc_maxlifetime');

		## Change the session timeout value to 60 minutes,  8*60*60 = 8 hours
		ini_set('session.gc_maxlifetime', 60*60);

		session_start();
		# Forcibly disable register_globals if php.ini does not do it already
		if (ini_get('register_globals')) {
			foreach ($_SESSION as $k=>$v) {
				unset(${$k});
			}
		}
	
        setSessionFmSettings();
	}

    /* determine if OB code has changed - do not use this during install, data not present yet*/
	if (!isset($doing_install) or !$doing_install) {
        $prevHash = Settings::get('version_hash');
        $allowCk = Settings::get('allow_auto_db_check');
        list($crntHash, $crntSize) = getOBVersionHash();
		//echo "crntHash=>$crntHash; prevHash=>$prevHash; allowChk=>$allowCk<br />\n";
        if (($crntHash != $prevHash) and (strpos($_SERVER['PHP_SELF'], 'dbChkrForms.php') === FALSE) AND ($allowCk == 'Y')) {
            //echo "Code hash has changed since last use<br />\n";
            header("Location: ../admin/dbChkrForms.php?tab=auto&rtnTo=$_SERVER[PHP_SELF]");
        }
        Settings::set('version_hash', $crntHash);
        Settings::set('OBsize', $crntSize);
    }

	//echo " crnt locale is $Locale";
	$LOC->init($Locale);

    // ***********************************************
    //Here is where we construct the actual web page
	include_once(REL(__FILE__, "../classes/Page.php"));
    // ***********************************************
    //echo "at end of common.php <br />\n";

	###################################################################
	## plugin Support
	###################################################################
	function getPlugIns($wanted) {
		## determine what is allowed
		if ($_SESSION['allow_plugins_flg'] != 'Y') return NULL;
		$list = $_SESSION['plugin_list'];
		$aray = explode(',', $list);

		## make connections where allowed
		clearstatcache();
		$pluginSet = array();
        $plugDir = '../plugins';
		if (is_dir($plugDir)) {
			## find all plugin directories
			$file = '';
            $dirSet = scandir($plugDir);
            foreach ($dirSet as $key => $plug) {
				# look at all plugin dirs
				if (in_array($file, array(".", ".."))) continue;
				$plugPath = "../plugins/$plug";
				if (is_dir($plugPath)) {
					if (!in_array($plug, $aray)) continue; // not allowed

                    $filSet = scandir($plugPath);
                    foreach ($filSet as $key => $file) {
						if (($file == '.') || ($file == '..')) continue;
						if ($file == $wanted) {
							$pluginSet[] = "$plugPath/$file";
						}
					}
				}
			}
		}
		return $pluginSet;
	}

	// Deprecated below, use the template-based functions - MS
	function H($s) {
		return htmlspecialchars($s, ENT_QUOTES);
	}
	function U($s) {
		return urlencode($s);
	}
	function HURL($s) {
		return H(U($s));
	}
	function JS($s) {
		$r=""; 
		$l=strlen($s); 
		$subs = array(
			'<' => '\\u003c',
			'>' => '\\u003e',
			'&' => '\\u0026',
			'\'' => '\\u0027',
			'"' => '\\u0022',
			'\\' => '\\\\',
			"\n" => '\\n',
			"\r" => '\\r',
		);
		for($i=0;$i<$l;$i++) {
			if (isset($subs[$s[$i]])) {
				$r .= $subs[$s[$i]];
			} else if(ord($s[$i]) < 32) {
				$r .= sprintf("\\u%04x", ord($s[$i]));
			} else {
				$r .= $s[$i];
			}
		} 
		return $r; 
	}
	function nT($n, $s, $v=NULL) {
		return T($s, $v);
	}
