<script language="JavaScript">
// JavaScript Document
// 11Apr2020 - FL - modified to include optional DOI  search
// 19Mar2020 - FL - added to OB.

"use strict";

class Ext {

	constructor () {
//console.log("in ext::constructor()");
		this.url = '../catalog/catalogServer.php';

		<?php
			if (($tab == 'user') || ($tab == 'opac')){
				echo "this.opacMode = true;";
			}
		?>

		this.initWidgets();
		this.resetForms();
		
		$('#otrBtn').on('click',null,this.otherSearch);
		$('#sciBtn').on('click',null,this.sciSearch);
		$('#doiBtn').on('click',null,this.doiSearch);
	};
	
	//------------------------------
	initWidgets () {
		// special menu for opac
		if (this.opacMode) {
			//console.log("enable menu for opac")
			obib.makeNav();
		}
	};
	resetForms () {
		$('#rsltsDiv').hide();
	  	$('#msgDiv').hide();
	};
	
	//------------------------------
	sciSearch (e) {
		console.log("doing 'sci-hub' search()");
  		let qryStr=$('#docKey').val();
		//console.log("query===>"+qryStr)
		$('#rslts').empty().html('for document:'+qryStr+'<br />');

        $.post( '../catalog/catalogServer.php', { 'mode':'doScihubSearch', 'query':qryStr }, function (data) {
					console.log('processing request');
		})
		.done (function(thePage) {
			console.log('got results');
			if (!thePage) {obib.showError('<?php T("Page not Found"); ?>'); }

			let result1 = thePage.match(/(<div id)\s*.*("citation")(.*>)(.*)(<\/div>)/);
			if (result1) {
				let citation = result1[4];
				$('#rslts').append("<fieldset id='citation' ><legend>Citation: </legend>"+citation+"</fieldset>");
			}

			let result2 = thePage.match(/(<iframe).*(src.*=.*\")(.*)(\".*id.*>)(<\/iframe>)/);
			if (result2) {
				let pdfLink = result2[0];
				$('#rslts').append("<fieldset id='article' ><legend>Article: </legend>"+pdfLink+"</fieldset>");
			}


			let iframe = $('#pdf');
			iframe.onload = function(){
				iframe.style.height = iframe.contentWindow.document.body.scrollHeight + 'px';
			}
			$('#rsltsDiv').show();
		})

		.fail( function () {
			console.log('request failed')
			obib.showError('<?php T("PageNotFound"); ?>');
		});
	};
	//------------------------------
	doiSearch (e) {
		console.log("doing 'DOI' search'");

  		var Qr=$('#docKey').val()
		if(Qr){
			if(Qr.indexOf('doi://')==0)Qr=Qr.substr(6);
			if(Qr.indexOf('doi:')==0)Qr=Qr.substr(4)

			//example doi: 10.1007/s10531-011-0143-8
			var newLoc = 'http://dx.doi.org/'+escape(Qr);
			window.open(newLoc,'doiWin');
			return false;
		}
	};
	//------------------------------
	otherSearch(e) {
		//https://www.uptodate.com/contents/search?search=covid-19&sp=0&searchType=PLAIN_TEXT&source=USER_INPUT&searchControl=TOP_PULLDOWN&searchOffset=1&autoComplete=false&language=&max=0&index=&autoCompleteTerm=
		//id: libksafh
		//pw: ViPuLa@#$322
		console.log("doing 'upToDate' search");

		// must successfully login at site first
		const url = "https://www.uptodate.com/";
        let siteReady = $.post ( '../catalog/catalogServer.php', { 'mode':'doOtrSrchLogin', 'url':url }, function (data) {
			console.log('logging in');
		})
		.fail ( function (data) {
			console.log('login failed: '+data)
			obib.showError('<?php T("PageNotFound"); ?>');
		});

		// now we can request a search
		let fullUrl = url + "contents/search";
		const qryPrefix = "search=";
		const params = "&sp=0&searchType=PLAIN_TEXT&source=USER_INPUT&searchControl=TOP_PULLDOWN&searchOffset=1&autoComplete=false&language=&max=0&index=&autoCompleteTerm="
		let qry = $('#docKey').val();
		let qryStr = "?" + escape(qryPrefix + qry + params);
		console.log(url+qryStr);

		siteReady.done (function () {
			$('#rslts').empty().html('for document:'+qry+'<br />');

		    $.post ( '../catalog/catalogServer.php', { 'mode':'doOtherSearch', 'url':fullUrl, 'query':qryStr }, function (data) {
			console.log('fetching page');
			})
			.done (function(thePage) {
				console.log('got page');
				console.log(thePage);
				if (!thePage) {
					obib.showError('<?php T("PageNotFound"); ?>');
				}

				let results = thePage.match(/(<div id="topicContent")(.*)(<\/div>)/);
				$('#rslts').append("<fieldset id='article' >"+results[0]+"</fieldset>");
				$('#rsltsDiv').show();
			})
			.fail ( function () {
				console.log('page request failed')
				obib.showError('<?php T("PageNotFound"); ?>');
			});
/*
			var newLoc = fullUrl+escape(qryStr);
			window.open(newLoc,'otrWin');
*/
		})
	}
}

$(document).ready(function () {
	var xxxx = new Ext();
});

</script>

