<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
   See the file COPYRIGHT.html for more details.
 */
?>
   
<script language="JavaScript" >
//------------------------------------------------------------------------------
// newItem Javascript - importCsvJs.php
"use strict";

let csvi = {
	init: function () {
		$('section').hide();
		$('.help').hide();
		csvi.initWidgets();
		csvi.autoBarcodeFlg = (<?php echo "'".$_SESSION['item_autoBarcode_flg']."'"; ?> == 'Y'?true:false);

		csvi.BCD_NEVER = 0;
		csvi.BCD_IF = 1;
		csvi.BCD_ALWAYS = 2;
	
		csvi.url = '../catalog/importServer.php';
		csvi.form = $('#specForm');
		
		/* input file delimiters */
		csvi.rcdTerminator = /\n\r|\r\n|\n/;
		csvi.fldTerminator = /\t/;

		csvi.getCollections();
		csvi.getMediaTypes();
		
		$('#imptSrce').on('change',null,function (e){
			$('#imptBtn').enable();
            csvi.fetchImportFileName(e)
		});
		$("#imptBtn").on('click',null,csvi.readFile);
		$("#helpBtn").on('click',null,function () {$('.help').toggle();});
		$(".bkupBtn").on('click',null,csvi.rtnToIntro);
		$("#Post2DbBtn").on('click',null,csvi.post2Db);
		$("#bcdDeflt").on('change',null,function () {csvi.bcdOpt = $('bcdDflt').val();});
		
		csvi.resetForm();
	},
	
	//------------------------------
	initWidgets: function () {
	},
	//----//
	resetForm: function () {
		//console.log('resetting Search Form');
		$('#errSpace').hide();
		$('.help').hide();
		csvi.setCopyDefault()
		$('#review').hide();
		$('#rslts').hide();
		$('#imptBtn').disable();
		$('#intro').show();
	},
	//----//
	rtnToIntro: function () {
		csvi.resetForm();
		$('#imptBtn').enable();
	},
	showHelp: function () {
		$('#help').show('norm');
	},
	closeHelp: function () {
		$('#help').hide('norm');
	},
	setCopyDefault: function () {
		if (csvi.autoBarcodeFlg) {
			$('#bcdDeflt').val(2);
		} else {
			$('#bcdDeflt').val(1);
		}
	},
		
	//------------------------------
	getCollections: function () {
		//console.log('getting collection list');
		csvi.collections = [];
		list.getPullDownList('Collection', $('#collectionCd'), csvi.collections);
	},
	//----//
	getMediaTypes: function () {
		//console.log('getting media list');
		csvi.mediaTypes = [];
		list.getPullDownList('Media', $('#materialCd'), csvi.mediaTypes);
	},
	//----//
	getDfltColl: function () {
		return $('#collectionCd').val();
	},
	getDfltMedia: function () {
		return $('#materialCd').val();
	},
	getOpacFlg: function () {
		return $('#opacFlg').val();
	},
	getShowAllFlg: function () {
		return ($('#showAll').val() == 'Y'?true:false);
	},
	//getTestTF: function () {
	//	return $('[name="test"]:checked').val();
	//},
	getDfltStatus: function () {
		return $('#code').val();
	},
	getCopyAction: function () {
		return $('#cpyAction').val();
	},
	isDupBarCd: function (barCd) {
/*
TODO				// Check for uniqueness with existing barcodes and new entries read.
  					$barcode = $rec["barcode_nmbr"];
					  if ($barcode != "") {
				    	if (in_array($barcode, $newBarcodes)) {
				    	  array_push($localErrors, T("biblioCopyQueryErr1"));
				    	  $validate = false;
				   	 } else {
								echo T("Barcode not present")."<br />";
							}
				  	  // push new barcode into validation array 
				  	  array_push($newBarcodes, $barcode);
					  }					  
*/
		return false;
	}, 

	//------------------------------
	fetchImportFileName: function (e) {
		// Get the FileList object from the file select event
		//console.log("accepting file name");

		let files = e.target.files;
		if(files.length === 0) return;
		csvi.file = files[0];
//		if(file.type !== '' && !file.type.match('image.*')) return;
	},

	//----//
	readFile: function () {
		//console.log('preparing to read file');
	    const reader = new FileReader();
	    reader.onload = function(event){
        	let file = event.target.result;
			csvi.records = file.split(csvi.rcdTerminator);
			//console.log(csvi.records);
			csvi.displayColHeads();
			csvi.processRows();
			$('#review').show();
	    };
		reader.onerror = function (event) {
			console.log('FileReader error: '+event.target.error.name);
			return;
		}
  		reader.readAsText(csvi.file);
	},

	//----//
	displayColHeads: function () {
		//console.log("printing column headings specified in the first record of the input file");
		let txt = "";
	  	const lineStart = '<tr><td class="center">';
		const lineEnd = '</td></tr>';

		let headerLine = csvi.records[0].trim();
		//console.log('header line: '+headerLine);
		//console.log(obib.ascii_to_hex(headerLine));

		//console.log("scanning header record");
	  	$('#colHeads').html('');
		csvi.heads = headerLine.split(csvi.fldTerminator);
		csvi.headings = [];
		for( let i=0; i<csvi.heads.length; i++) {
			let rawHeading = csvi.heads[i];
			let heading = rawHeading.replace(/"/g, '');  // remove leading and trailing double quotes
			let lineMid = '</td><td class="center" id="tag' + heading + '" >';
			csvi.headings.push(heading);

		  	switch (heading) {
		  		case 'barCo':
		  			txt += lineStart + heading + lineMid + '<?php echo T("Barcode Number"); ?>' + lineEnd;
		  			break;
		  		case "coll":
		  		 	txt += lineStart + heading + lineMid + '<?php echo T("Collection"); ?>' + lineEnd;
		 		   	break;
		  		case "media":
		    		txt += lineStart + heading + lineMid + '<?php echo T("Media Type"); ?>' + lineEnd;
		    		break;
		  		case "opac?":
		  		  	txt += lineStart + heading + lineMid + '<?php echo T("opacFlag"); ?>' + lineEnd;
		  		  	break;
				default:
					let pattern = /^[0-9][0-9]*\$[a-z]$/;
				    if (pattern.test(heading)) {
						//console.log('valid tag format: ' + heading);
				    	csvi.fetchTagDescription(lineStart, lineEnd, heading);
				    } else {
						console.log('invalid tag format: '+heading);
		      			txt = <?php echo "'<td".' class="center"'.">".T("CSVunknownIgnored")."</td></tr>'"; ?>;
		    		}
	  		}
		}
	  	$('#colHeads').append(txt);
		//console.log(csvi.headings);
	},
	//----//

	fetchTagDescription: function (lineStart, lineEnd, tag) {
		console.log('decoding tag: '+tag)
        $.post(csvi.url, {'mode':'getMarcDesc', 'code':tag }, function(data){
console.log(tag+" desc = '"+response+"'");
//console.log(response);
			let lineMid = '</td><td class="center" id="tag'+ tag + '" >';
			$('#colHeads').append(lineStart + heading + lineMid + response + lineEnd);
		}, 'json');
	},
	/* ---- */

	processRows: function () {
console.log("processing file data rows");
		let rec = {};	// output record
		const csvRcrds = $('#csvRcrds'); csvRcrds.html(' ');
		const csvErrs = $('#csvErrs'); csvErrs.html(' ');
		const showAll = csvi.getShowAllFlg();
		csvi.csvRecords = [];
        const dfltColl = $('#collectionCd option:selected').html();
console.log('default coll ==>> '+dfltColl);
        const dfltMatl = $('#materialCd option:selected').html();
console.log('default matll ==>> '+dfltMatl);
		//console.log('showAll='+showAll);
		//console.log('bcdDflt='+$('#bcdDeflt').val());
	
  		let mandatoryCols = {
  			'coll'  : false,		// collection name
  			'media' : false,		// media type name
		};

		/* setup for with barcodes */
		const width = <?php echo $_SESSION['item_barcode_width']; ?>;
		let w = width;
	 	if( width <= 1 ) w = 13;
	  	
		for (let line=1; line<csvi.records.length; line++) {
			let crntLine = csvi.records[line];
			if (crntLine.length <= 0) break;
console.log('working row #'+(line+1)+' of '+csvi.records.length+' : '+crntLine);
					
			/* break an input line into an array of its parts */
			let data = crntLine.split(csvi.fldTerminator);
console.log('data flds: '+data);

			if (showAll) {
				csvRcrds.append(' <tr><td colspan="3">&nbsp</td></tr>\n');
    			csvRcrds.append(' <tr><td colspan="3"> - - - - - - - Line #'+line+' - - - - - - - - </td></tr>\n');
			}

			let fields = {},
				rec = {};

			/* default options */
			rec['copy_desc'] = $('#copyText').val();
			rec['copy_action'] = csvi.getCopyAction();
			rec['status_cd'] = csvi.getDfltStatus();

//console.log(rec);
console.log("copy desc="+rec['copy_desc']+"; copy action="+rec['copy_action']+"; status="+rec['status_cd']);

			for (let n=0; n<csvi.headings.length; n++) {
				let target = csvi.headings[n];
				let fldData = (data[n].trim()).replace(/"/g, '');
				let flg = false;
				let	txt = '';

console.log("working column #"+(n)+" of "+csvi.headings.length+" with '" + target + "' entry of '"+ fldData +"'");

				/* if current column is a 'mandatory' and is present in headings mark as 'seen' */
    			if ( mandatoryCols[target] ) mandatoryCols[target] = true;
    		
	    		switch (target) {
	    			case 'barCo':
	    				/* pad bar code to proper size */
	      				rec['barcode_nmbr'] = flos.nmbrpad(fldData, w);
						if (csvi.isDupBarCd()) {
							csvErrs.append(' <tr><td colspan="3" class="label">'+<?php echo "'".T("LineNmbr")."'"; ?>+i+<?php echo "'".T("Barcode")."'"; ?>
																+' '+rec['barcode_nmbr']+<?php echo " '".T("isaDup")."'"; ?>+"</td></tr>\n");
							//continue;
						} else {
	    	  				if (showAll) csvRcrds.append(' <tr><td class="label">'+<?php echo "'".T("Barcode")."'"; ?>+"</td><td>&nbsp;</td><td>"+rec['barcode_nmbr']+"</td></tr>\n");
	    	  			}
	      				if ( ( parseInt(rec['barcode_nmbr']) == 0 ) && ( csvi.bcdDflt >= csvi.BCD_IF ) ){
								rec['barcode_nmbr'] = 'autogen';
						}
	    				break;

				    case "coll":
						if (fldData == '') {
							console.log('collection name absent, using default: '+dfltColl);
							txt = ' <?php echo T("absent"); ?>';
							flg = true;
                            rec['collection_cd'] = dfltColl;
						} else if (!csvi.collections.indexOf(fldData)) {
							console.log("collection name '"+fldData+"' invalid, using default: "+dfltColl);
							txt = "'"+fldData+"' <?php echo T("invalid"); ?>";
							flg = true;
                            rec['collection_cd'] = dfltColl
						} else {
							console.log('using specified collection name: '+fldData);
				      		rec['collection_cd'] = fldData;
						}
						if (flg) {
							csvErrs.append(' <tr><td colspan="3">' + <?php echo "'".T("LineNmbr")."'"; ?>+line+" " +
											 <?php echo "'".T("Collection")."'"; ?>+" "+txt+"; <?php echo T("using default"); ?>: '"+
											 dfltColl+"'</td></tr>\n");
						}
	      				if (showAll) csvRcrds.append("  <tr><td>"+<?php echo "'".T("Collection")."'"; ?>+"</td><td>&nbsp;</td><td>"+rec['collection_cd']+"</td></tr>\n");
				      	break;

	    			case 'media':
						if (fldData == '') {
							console.log('media name absent, using default: '+dfltMatl);
							txt = ' <?php echo T("absent"); ?>';
							flg = true;
                            rec['material_cd'] = dfltMatl;
						} else if (!csvi.mediaTypes.indexOf(fldData)) {
							console.log("media name '"+fldData+"' invalid, using default: "+dfltMatl);
							txt = "'"+fldData+"' <?php echo T("invalid"); ?>";
							flg = true;
                            rec['material_cd'] = dfltMatl
						} else {
							console.log('using specified media name: '+fldData);
				      		rec['material_cd'] = fldData;
						}
						if (flg) {
							csvErrs.append(' <tr><td colspan="3">' + <?php echo "'".T("LineNmbr")."'"; ?>+line+" " +
											 <?php echo "'".T("Media")."'"; ?>+" "+txt+"; <?php echo T("using default"); ?>: '"+
											 dfltMatl+"'</td></tr>\n");
						}
	      				if (showAll) csvRcrds.append("  <tr><td>"+<?php echo "'".T("Media")."'"; ?>+"</td><td>&nbsp;</td><td>" + rec['material_cd'] + "</td></tr>\n");
				      	break;

				    case "opac?":
						let patternYes = /^[yYtT]/;
						let patternNo = /^[nNfF]/;

				    	if (patternYes.test(fldData)) {
				        	rec["opac_flg"] = true;
				      	} else if (patternNo.test(fldData)) {
				        	rec["opac_flg"] = false;
				      	} else {
				        	rec["opac_flg"] = csvi.getOpacFlg();
				      	}
	      				if (showAll) csvRcrds.append("  <tr><td>"+<?php echo "'".T("Show in OPAC")."'"; ?>+"</td><td>&nbsp;</td>" +
	      											"<td>"+(rec["opac_flg"] == true?"true":"false")+"</td><tr>\n");
				      	break;

				    default:
				    	let pattern = /^[0-9][0-9]*\$[a-z]$/;
				      	if (pattern.test(target)) {
				        	let tag = target.split('$');
							let tgt = { 'tag':tag[0], 'subfield_cd':tag[1], 'data':fldData };
							fields[target] = tgt;

		      				if (showAll) csvRcrds.append("  <tr><td>"+tag[0]+"</td>" +
		      											"<td>"+tag[1]+"</td>" +
		      											"<td>"+fldData+"</td></tr>\n");
				      	}
				      	break;
				  }
			}

			/* check for barcode present, and add if user wishes */
			if ((! rec['barcode_nmbr'] ) && ( $('#cpyAction').val() == csvi.BCD_ALWAYS )){
				csvErrs.append(' <tr><td colspan="3">Line #'+line+" "+<?php echo "'".T("barcode missing, auto-generating")."'"; ?>+"</td></tr>\n");
      			rec['barcode_nmbr'] = 'autogen';
			}

			/* now add 'fields array' to record */
			rec['fields'] = fields
console.log(rec);
			csvi.csvRecords[line-1] = rec;
		}	
		
		/* parsing complete, ready to send to server for posting to database */
console.log(csvi.csvRecords);
	},
	
	post2Db: function () {
console.log('sending '+csvi.csvRecords.length+' records to OB database now');
		$('#intro').hide();
		$('#review').show();
		$('#rslts').show();

		$('#csvImportRslts').html('<ul id="postRslt"></ul>');
		for (let i=0; i<csvi.csvRecords.length; i++) {
			csvi.postOneRecd(csvi.csvRecords[i]);
		}
	},
	postOneRecd: function (aRcd) {
console.log(aRcd);
		$.post(csvi.url, {'mode':'postCsvData',
						  'record':aRcd,
						  'userid':$('#userid').val()
						},
						function (response) {
							$('#postRslt').append('<li>'+response+'</li>');
		});
	},
};

$(document).ready(csvi.init);

</script>
