<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */

/**
 * back-end API for Existing Biblio Management
 * @author Luuk Jansen
 * @author Fred LaPlante
 **/

	require_once("../shared/common.php");
	require_once(REL(__FILE__, "../functions/inputFuncs.php"));
	require_once(REL(__FILE__, "../functions/utilFuncs.php"));
	require_once(REL(__FILE__, "../model/Settings.php"));
	require_once(REL(__FILE__, "../model/Biblios.php"));
	require_once(REL(__FILE__, "../model/BiblioImages.php"));
	require_once(REL(__FILE__, "../model/Copies.php"));
	require_once(REL(__FILE__, "../model/CopyStatus.php"));
	require_once(REL(__FILE__, "../model/CopiesCustomFields.php"));	
 	require_once(REL(__FILE__, "../model/BiblioCopyFields.php"));

	require_once(REL(__FILE__, "../classes/Biblio.php"));
	require_once(REL(__FILE__, "../classes/Copy.php"));

	## Load session data in case of OPAC (eg no user logged on)
	if(empty($_SESSION['show_checkout_mbr'])) $_SESSION['show_checkout_mbr'] = Settings::get('show_checkout_mbr');	
	if(empty($_SESSION['show_detail_opac'])) $_SESSION['show_detail_opac'] = Settings::get('show_detail_opac');	
	if(empty($_SESSION['multi_site_func'])) $_SESSION['multi_site_func'] = Settings::get('multi_site_func');
	if(empty($_SESSION['show_item_photos'])) $_SESSION['show_item_photos'] = Settings::get('show_item_photos');	
	if(empty($_SESSION['items_per_page'])) $_SESSION['items_per_page'] = Settings::get('items_per_page');
	
	## Adjusted, so that if 'library_name' contains a string, the site is put by default on 1.
	if(empty($_SESSION['current_site'])) {
		if(isset($_COOKIE['OpenBiblioSiteID'])) {
			$_SESSION['current_site'] = $_COOKIE['OpenBiblioSiteID'];				
		} elseif($_SESSION['multi_site_func'] > 0){
			$_SESSION['current_site'] = $_SESSION['multi_site_func']; 			
		} else {
			$_SESSION['current_site'] = 1;
		}		
	}

	## fetch opts here for general use as needed
	$opts['lookupAvail'] = in_array('lookup2',$_SESSION);
	$opts['current_site'] = $_SESSION['current_site'];
	$opts['showBiblioPhotos'] = $_SESSION['show_item_photos'];
	$opts['barcdWidth'] = $_SESSION['item_barcode_width'];

	## --------------------- ##
	//echo "in catalogSrvr, at start: ";print_r($_POST);echo "<br />\n";

	switch ($_POST['mode']) {

	case 'doBibidSearch':
	  	$bib = new Biblio($_POST[bibid]);
	  	echo json_encode($bib->getData());
	  	break;

	case 'doBarcdSearch':
	  	$ptr = new Copies;
	  	$copy = $ptr->getByBarcode($_POST['searchBarcd']);
	  	if ($copy != NULL) {
	  		$bib = new Biblio($copy['bibid']);
	  		echo json_encode($bib->getData());
	  	} else {
        	echo '{"message":"' . T("No copy with barcode") . '"}';
	  	}
	  	break;

	case 'doPhraseSearch':
		## fetch a list of all biblio meeting user search criteria
		$criteria = $_POST;
	    $theDb = new Biblios;
		$biblioLst = $theDb->getBiblioByPhrase($criteria);
		//echo "in catalogSrvr, doPhraseSearch: "; print_r($biblioLst);echo "<br />\n";
		if (sizeof($biblioLst) > 0) {
			$srchRslt = array();
			## succesful search, deal with results
			// Add amount of search results.
			if($_POST['firstItem'] == null){
				$firstItem = 0;
			} else {
				$firstItem = $_POST['firstItem'];
			}
			if($_SESSION['items_per_page'] <= sizeof($biblioLst) - $firstItem){
				$lastItem = $firstItem + $_SESSION['items_per_page'];
			} else {
				$lastItem = sizeof($biblioLst);
			}
			
			## multi-page record header
			$rcd['totalNum'] = sizeof($biblioLst);
			$rcd['firstItem'] = $firstItem;
			$rcd['lastItem'] = $lastItem;
			$rcd['itemsPage'] = $_SESSION['items_per_page'];
			$srchRslt[] = json_encode($rcd);

			## show as many as user settings specify
			## not the most efficient way to get the whole result query, this should be rewritten
			$iterCounter = 0;
			//echo "biblioList==> ";print_r($biblioLst);echo "<br />\n";
			foreach ($biblioLst as $bibid) {
				## Skip over previously requested items and break when amount of items is past - LJ
				//echo $bibid."<br />\n";
				$iterCounter++;
				if($iterCounter - 1 < $firstItem) continue;
				if($iterCounter > $lastItem) break;
				####
				## at this point we have a just a list of biblios meeting the users criteria,
				## now we create a Biblio object for each item in list and add content to $srchRslt
				####
		  		$bib = new Biblio($bibid);
		  		$rslt = json_encode($bib->getData());
				//echo "biblio data==> ";print_r($rslt);echo "<br />\n";
		  		$srchRslt[] = $rslt;
				unset($bib); ## object no longer needed, destroy it
			}
			echo json_encode($srchRslt);
		} else {
			echo '[]';
		}
		break;

	case 'doScihubSearch':
		## fetch complete document from repository
		//echo "In catalogServer::doSciHubSearch<br />\n";
		$url = "https://sci-hub.tw";
		$qry = $_POST['query'];
		$qryStr = $url."/".$qry;

		$ch = curl_init($qryStr);
		curl_exec($ch);
		if($errno = curl_errno($ch)) {
    		echo 'Curl error: ' . curl_error($ch) . "<br />\n";
		}
		curl_close($ch);

		echo $ch;
		break;

	case 'doOtrSrchLogin':
 		//echo "in catalogServer::doOtrSrchLogin, input==><br />\n\t";print_r($_POST);echo "<br />\n";

		// THIS ARRAY CONTAINS THE INPUT FIELDS DATA
   		$data = array(
                 'username' => 'libksafh',
                 'password' => 'ViPuLa@#$322'
   		);
		$url = $_POST['url'];

		// START THE CURL PROCESS
		$ch = curl_init(); // initialize
		curl_setopt($ch, CURLOPT_URL, $url."/login"); // form location url
		curl_setopt($ch, CURLOPT_POST, 1); // form method
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // input fileds
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // get form result details
		$html = curl_exec($ch); // execute the curl process

		if($errno = curl_errno($ch)) {
    		echo 'Curl error: ' . curl_error($ch) . "<br />\n";
		}
		curl_close($ch);
		echo $ch;
		break;

	case 'doOtherSearch':
		## fetch complete document from repository
		//echo "In catalogServer::doOtherSearch<br />\n";
		$url = $_POST['url'];
		$qryStr = $_POST['query'];
		$ch = curl_init(); // initialize
		curl_setopt($ch, CURLOPT_URL, ($url.$qryStr)); // form location url
//        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // return output as a string
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; ) Gecko/20100101 Firefox/76.0');

		$data = curl_exec($ch);
		if($errno = curl_errno($ch)) {
    		echo 'Curl error: ' . curl_error($ch) . "<br />\n";
		}
		curl_close($ch);

		echo $data;
		break;

	## --------------------- ##

	case 'setCurrentSite':
		$crntSite = $_POST['siteid'];
		$_SESSION['current_site'] = $crntSite;
		echo json_encode('crntSite set to '.$crntSite);
		break;

	case 'getCrntMbrInfo':
		require_once(REL(__FILE__, "../functions/info_boxes.php"));
		echo currentMbrBox();
	    break;
 	case 'getMediaDisplayInfo':
		require_once(REL(__FILE__, "../model/MaterialFields.php"));
		$theDb = new MaterialFields;
		$media = $theDb->getDisplayInfo($_GET['howMany']);
		echo json_encode($media);
		break;
	case 'getMediaLineCnt':
		require_once(REL(__FILE__, "../model/MediaTypes.php"));
		$theDb =new MediaTypes;
		$set = $theDb->getAll('code');
		//while ($row = $set->fetch_assoc()) {
        foreach ($set as $row) {
		  $media[$row['code']] = $row['srch_disp_lines'];
		}
		echo json_encode($media);
		break;

	case 'addToCart':
		require_once(REL(__FILE__, "../model/Cart.php"));
		$name = $_POST['name'];
		$cart = getCart($name);
		if (isset($_POST['id'])) {
			foreach ($_POST['id'] as $id) {
				$rslt = $cart->contains($id);
				if (!$rslt) $cart->add($id);
			}
		}
	  break;

	case 'getNewBarcd':
		$copies = new Copies;
		$temp['barcdNmbr'] = $copies->getNewBarCode($_SESSION[item_barcode_width]);
		echo json_encode($temp);
	  break;	  

	case 'chkBarcdForDupe':
	  $copies = new Copies;
	  if ($copies->isDuplicateBarcd($_POST[barcode_nmbr],$_POST[copyid])) {
          echo "Barcode $_POST[barcode_nmbr]: " . T("Barcode number already in use.");
      }
      break;

	case 'getBiblioFields':
		require_once(REL(__FILE__, "../model/MaterialFields.php"));
		$theDb = new Biblios;
		$theDb->getBiblioFields();
		break;

	case 'getCopyInfo':
	    $bib = new Biblio($_POST['bibid']);
		$bibData = $bib->getData();
		//$cpyList = $bibData['cpys'];
		$cpyList = $bib->fetch_copyList();
        //echo "in catalogServer, getCopyInfo, cpyList = ";print_r($cpyList);echo "<br />\n";
		foreach ($cpyList as $cid) {
			$cpy = new Copy($cid);
			$cpys[] = $cpy->getData();
			unset($cpy); # no longer needed
		}
		echo json_encode($cpys);
	  break;

	case 'updateBiblio':
		## fetch biblio object with current DB data
	    $bib = new Biblio($_POST['bibid']);
		## overwrite header with screen content
		$hdr['bibid'] = $_POST['bibid'];
		$hdr['material_cd'] = $_POST['materialCd'];
		$hdr['collection_cd'] = $_POST['collectionCd'];
		$hdr['opac_flg'] = $_POST['opacFlg'];
		$msg = $bib->setHdr($hdr);
		if(isset($msg)) die ($msg);
		## overwrite marc fields with screen content (new or modified))
		foreach ($_POST['fields'] as $key=>$val) {
			$marc[$key] = array('data'=>$val['data'],'codes'=>$val['codes']);
		}
		$msg = $bib->setMarc($marc);
		if(isset($msg)) die ($msg);
		## tell biblio object to post itself to DB
		$msg = $bib->updateDB();
	    echo $msg;
	    break;

	case 'deleteBiblio':
        $bibs = new Biblio($_POST['bibid']);
        $bibs->deleteBiblio();
        echo T("Delete completed");
        break;

	case 'deleteMultiBiblios':
		$bibs = new Biblios;
		foreach ($_POST['bibList'] as $bibid) {
			$bibs->deleteOne($bibid);
		}
		echo T("Delete completed");
		break;

	//// ====================================////
	case 'newCopy':
        $copies = new Copies;
        if ($copies->isDuplicateBarcd($_POST['barcode_nmbr'], $_POST['copyid'])) {
        	echo "Barcode $_POST[barcode_nmbr]: ". T("Barcode number already in use.");
        	return;
        }
        $theDb = new Copies;
        echo $theDb->insertCopy($_POST['bibid'],$_POST['copyid']);
        break;
	case 'updateCopy':
	    $theDb = new Copies;
	    echo $theDb->updateCopy($_POST['bibid'],$_POST['copyid']);
		break;

	case 'getBibsFrmCopies':
	  $theDb = new Copies;
		$rslt = $theDb->getBibsForCpys($_GET['cpyList']);
	  echo json_encode($rslt);
	  break;
	case 'deleteCopy':
	    $theDb = new Copies;
		//echo $theDb->deleteCopy($_POST['bibid'],$_POST['copyid']);
		echo $theDb->deleteCopy($_POST['copyid']);
		break;

	case 'deleteMultiCopies':
	    $theDb = new Copies;
		foreach ($_POST['cpyList'] as $copyid) {
			echo $theDb->deleteCopy($copyid);
		}
		break;

	//// ====================================////
	case 'getPhoto':
	    $ptr = new BiblioImages;
	    $set = $ptr->getByBibid($_POST['bibid']);
        foreach ($set as $row) {
		    $imgs[] = $row;
		}
		echo json_encode($imgs);
	    break;

	case 'updatePhoto':
	    $ptr = new BiblioImages;
	    ### left as an exercise for the motivated - FL (I'm burned out on this project)
		break;
	case 'addNewPhoto':
		define('UPLOAD_DIR', '../photos/');
		$file = UPLOAD_DIR . $_POST['url'];
		$img = $_POST['img'];
		if (substr($file, -3,3) == 'png')
			$imgFmt = 'png';
		 else
			$imgFmt = 'jpeg';
		$img = str_replace('data:image/'.$imgFmt.';base64,', '', $img);
		$img = str_replace(' ', '+', $img);
		$data = base64_decode($img);
		$success = file_put_contents($file, $data);
		if ($success) {
	  		$ptr = new BiblioImages;
			$err = $ptr->appendLink_e($_POST['bibid'], $_POST['caption'], $data, $file);
			if(isset($err)) {
				print_r($err);
				break;
			}
	  		$set = $ptr->getByBibid($_POST['bibid']);
            	foreach ($set as $row) {
				$imgs[] = $row;
			}
			echo json_encode($imgs);
		} else {
			echo "Unable to save the file < $file >.\n";
			//print_r($_POST);
		}
		break;

	case 'addNewRemotePhoto':
        $ptr = new BiblioImages;
		$caption = $_POST['caption'] ? $_POST['caption'] : 'Cover';
        $err = $ptr->insert_el(array('bibid' => $_POST['bibid'], 'caption' => $caption, 'url' => $_POST['url'], 'imgurl' => $_POST['url']));
        if(isset($err)) {
                print_r($err);
                break;
        }
        $set = $ptr->getByBibid($_POST['bibid']);
        foreach ($set as $row) {
                $imgs[] = $row;
        }
        echo json_encode($imgs);
		break;

	case 'deletePhoto':
	    $ptr = new BiblioImages;
		$rslt = $ptr->deleteByBibid($_POST['bibid']);
        echo json_encode($rslt);
		define('UPLOAD_DIR', '../photos/');
		//echo "upload dir==>".'UPLOAD_DIR';
		$file = 'UPLOAD_DIR' . $_POST['url'];
        unlink($file);
		break;

	//// ====================================////
	default:
	  echo "<h5>Invalid mode: " . $_POST['mode'] . "</h5>";
	}
